package gov.va.med.mhv.admin.service.mhvusers;

import java.util.Collection;
import java.util.List;
import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;

public interface InPersonAuthenticationService {

	public Boolean isPatientAuthenticated(Long patientId) throws MHVException;

	public InPersonAuthenticationDTO getIPAPatientById(Long patientId) throws MHVException;

	public ResponseUtil<List<InPersonAuthenticationDTO>> forceUnauthenticateUnCorrelateWithAdminUserName(Long ipaId, String adminUserName)
			throws MHVException;

	public ResponseUtil<InPersonAuthenticationDTO> getAuthenticationForPatient(Long patientId) throws MHVException;
	
	public ResponseUtil<InPersonAuthenticationDTO> getIPAByPatientId(Long patientId) throws MHVException;

	public ResponseUtil<List<InPersonAuthenticationDTO>> unauthenticateWithAdminUserName(Long ipaId, String adminUserName, String removeAuthenticatingReason) throws MHVException;

	public ResponseUtil<List<InPersonAuthenticationDTO>> authenticateWithAdminUserName(Long ipaId, String adminUserName, Long authenticatingFacilityId) throws MHVException;
	
	public ResponseUtil<List<InPersonAuthenticationDTO>> deferAuthentication(InPersonAuthenticationDTO ipaDTO) throws MHVException;	

	public ResponseUtil<List<InPersonAuthenticationDTO>> terminateAuthentication(InPersonAuthenticationDTO ipaDTO) throws MHVException;	

	public ResponseUtil<PatientDTO> match(UserProfileDTO uProfileDTO, String adminUserName) throws MHVException;	
	
	public ResponseUtil<List<InPersonAuthenticationDTO>> syncCorrelate(InPersonAuthenticationDTO ipaDTO, String adminUserName) throws MHVException;	

	public ResponseUtil<List<InPersonAuthenticationDTO>> authenticateMany(String patientIds, String adminUserName) throws MHVException;	
	/**
	 * Execute the GetIPAPatientById operation
	 *
	 * @param patientId
	 * @return InPersonAuthenticationServiceResponse
	 */
	/*
	 * void getIPAPatientById(Long patientId, ResponseUtil response);
	 *
	 *//**
		 * Execute the GetIPAPatientById operation
		 *
		 * @param userProfileid
		 * @return InPersonAuthenticationServiceResponse
		 */
	/*
	 * void getIPAByuserProfileid(Long userProfileid, ResponseUtil response);
	 *
	 *//**
		 * Determines whether the user with the given user name is an
		 * in-person-authenticated (IPA-ed) patient. Return a Patient instance
		 * if the user is an IPAed patient; null otherwise.
		 *
		 * @param userName
		 *            The name of the user to determine IPA status for.
		 * @return PatientServiceResponse
		 */
	/*
	 * void getIPAedPatientForUser(String userName, ResponseUtil response);
	 *
	 *//**
		 * Execute the DeferAuthentication operation
		 *
		 * @param ipa
		 * @return InPersonAuthenticationServiceResponse
		 */
	/*
	 * void deferAuthentication(InPersonAuthenticationDTO ipa, ResponseUtil
	 * response);
	 *
	 * void deferAuthenticationLight(InPersonAuthenticationDTOLight ipa,
	 * ResponseUtil response);
	 *//**
		 * Execute the TerminateAuthentication operation
		 *
		 * @param ipa
		 * @return InPersonAuthenticationServiceResponse
		 */
	/*
	 * void terminateAuthentication(InPersonAuthenticationDTO ipa, ResponseUtil
	 * response);
	 *
	 *//**
		 * Execute the FindPatients operation
		 *
		 * @param criteria
		 * @return PatientInformationCollectionServiceResponse
		 */
	/*
	 * // void findPatients(InPersonAuthenticationCriteria criteria,
	 * ResponseUtil response);
	 *
	 *//**
		 * Execute the AuthenticateMany operation
		 *
		 * @param patientIds
		 * @return VoidServiceResponse
		 */
	/*
	 * void authenticateMany(Collection patientIds, ResponseUtil response);
	 *
	 *//**
		 * Execute the FinalizeAuthentication operation
		 *
		 * @param ipa
		 * @param error
		 *            Not null if and only if an error occurred.
		 * @return InPersonAuthenticationServiceResponse
		 */
	/*
	 * void finalizeAuthentication(InPersonAuthenticationDTO ipa, String error,
	 * ResponseUtil response);
	 *
	 *//**
		 * Execute the GetAuthenticationForPatient operation
		 *
		 * @param patientId
		 * @return InPersonAuthenticationServiceResponse
		 */
	/*
	 * void getAuthenticationForPatient(Long patientId, ResponseUtil response);
	 *
	 *//**
		 * Execute the Unauthenticate operation
		 *
		 * @param ipa
		 * @return InPersonAuthenticationServiceResponse
		 */
	/*
	 * void unauthenticate(InPersonAuthenticationDTO ipa, ResponseUtil
	 * response);
	 *
	 *//**
		 * Execute the FinalizeUnauthentication operation
		 *
		 * @param ipa
		 * @param error
		 *            Not null if and only if an error occurred.
		 * @return InPersonAuthenticationServiceResponse
		 */
	/*
	 * void finalizeUnauthentication(InPersonAuthenticationDTO ipa, String
	 * error, ResponseUtil response);
	 *
	 *//**
		 * Execute the SaveIPA operation
		 *
		 * @param ipa
		 * @return VoidServiceResponse
		 */
	/*
	 * InPersonAuthenticationDTO saveIPA(InPersonAuthenticationDTO ipa);
	 * //InPersonAuthentication
	 * saveInPersonAuthentication(InPersonAuthenticationDTO ipa);
	 * //InPersonAuthenticationLight
	 * saveInPersonAuthenticationLight(InPersonAuthenticationDTOLight ipa);
	 * //InPersonAuthenticationLight saveIPALight(InPersonAuthenticationLight
	 * ipa);
	 *
	 *//**
		 * Execute the ForceUnauthenticateUnCorrelate operation
		 *
		 * @param ipa
		 * @return InPersonAuthenticationServiceResponse
		 */
	/*
	 * void forceUnauthenticateUnCorrelate(InPersonAuthenticationDTO ipa,
	 * ResponseUtil response);
	 *
	 *//**
		 * Execute the IsPatientAuthenticated operation
		 *
		 * @param patientId
		 * @return BooleanServiceResponse
		 */
	/*
	 * void isPatientAuthenticated(Long patientId, ResponseUtil<Boolean>
	 * response);
	 *
	 *//**
		 * Execute the Authenticate operation
		 *
		 * @param ipa
		 * @return InPersonAuthenticationServiceResponse
		 *//*
		 * void authenticateFull(InPersonAuthenticationDTO ipa, ResponseUtil
		 * response);
		 *
		 * void authenticate(InPersonAuthenticationDTOLight ipa, ResponseUtil
		 * response);
		 */


}
